#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_SpecimenTest : BaseTest 
	{
		private DataTable _dtSpecimenTest;
		private DataTable _dtOrderedTest;
		private DataTable _dtCannedComment;
		private DateTime _currentDateTime;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//**Get SpecimenTest data
				this._dtSpecimenTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM SpecimenTest WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//***Get OrderedTest data
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE PatientSpecimenGuid IS NOT NULL AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//***Get CannedComment data
				this._dtCannedComment = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM CannedComment WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}

			this._currentDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		[Test]
		public void InvalidateSpecimenTestResults_Pass()
		{
			this.RefreshData = true;

			System.Guid orderedTestGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];
			byte[] otRowVersion = (byte[])this._dtOrderedTest.Rows[0][TABLES.OrderedTest.RowVersion];

			System.Guid specimenTestGuid = (System.Guid)this._dtSpecimenTest.Rows[0][TABLES.SpecimenTest.SpecimenTestGuid];
			byte[] stRowVersion = (byte[])this._dtSpecimenTest.Rows[0][TABLES.SpecimenTest.RowVersion];

			DataTable dtSpecimenTest = SprocHelper.GetUpdateSpecimenTestStatusSprocTable(specimenTestGuid, stRowVersion);
			DataTable dtOrderedTest = SprocHelper.GetUpdateOrderedTestStatusSprocTable(orderedTestGuid, otRowVersion);
			dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid] = this._dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid];

			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient JOIN PatientSpecimen ON Patient.PatientGuid = PatientSpecimen.PatientGuid WHERE PatientSpecimen.PatientSpecimenGuid = '"+dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid].ToString()+"'");
			System.Guid[] patientGuids = new System.Guid[1];
			patientGuids[0] = (Guid)drPatient[TABLES.Patient.PatientGuid];
			
			DataRow dr = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM PatientTransfusionRequirement WHERE RecordStatusCode = 'A' AND CreateDivisionCode = '"+UnitTestConfig.TestDivisionCode+"'");

			DataTable dtTransfusionRequirement = new DataTable(Common.VbecsTables.PatientTransfusionRequirement.TableName);
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid, typeof(System.Guid));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.InactivationComment, typeof(string));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.InactivateDate, typeof(System.DateTime));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.InactivateUser, typeof(string));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.InactivateDivisionCode, typeof(string));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.RecordStatusCode, typeof(string));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusionRequirement.RowVersion, typeof(byte[]));
			dtTransfusionRequirement.Columns.Add(TABLES.PatientTransfusion.DivisionCode, typeof(string));
			DataRow drTransfusionReq = dtTransfusionRequirement.NewRow();
			drTransfusionReq[TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = dr[TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid];
			drTransfusionReq[TABLES.PatientTransfusionRequirement.InactivationComment] = "Unit Test 1383";
			drTransfusionReq[TABLES.PatientTransfusionRequirement.InactivateDate] = DateTime.Now;
			drTransfusionReq[TABLES.PatientTransfusionRequirement.InactivateUser] = Environment.UserName;
			drTransfusionReq[TABLES.PatientTransfusionRequirement.InactivateDivisionCode] = UnitTestConfig.TestDivisionCode;								
			drTransfusionReq[TABLES.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
			drTransfusionReq[TABLES.PatientTransfusionRequirement.RowVersion] = dr[TABLES.PatientTransfusionRequirement.RowVersion];
			drTransfusionReq[TABLES.PatientTransfusion.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dtTransfusionRequirement.Rows.Add(drTransfusionReq);

			DataTable dtPatient = new DataTable();
			dtPatient.Columns.Add(Common.VbecsTables.Patient.PatientGuid, typeof(System.Guid));
			dtPatient.Columns.Add(Common.VbecsTables.Patient.AboRhChangeIndicator, typeof(byte));
			dtPatient.Columns.Add(Common.VbecsTables.Patient.RowVersion, typeof(byte[]));
			//
			DataRow drUpdatePatient = dtPatient.NewRow();
			drUpdatePatient[Common.VbecsTables.Patient.PatientGuid] = drPatient[Common.VbecsTables.Patient.PatientGuid];
			drUpdatePatient[Common.VbecsTables.Patient.AboRhChangeIndicator] = false;
			drUpdatePatient[Common.VbecsTables.Patient.RowVersion] = drPatient[Common.VbecsTables.Patient.RowVersion];
			dtPatient.Rows.Add(drUpdatePatient);

			//Insert an AntiseraOrderedTest record so that we can inactivate it!
			DataRow drRackLot = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM dbo.RackLot");
			Guid antiseraOrderedTestGuid = Guid.NewGuid();
			string insertSql = "INSERT INTO dbo.AntiseraOrderedTest (";
			insertSql += TABLES.AntiseraOrderedTest.AntiseraOrderedTestGuid+",";
			insertSql += TABLES.AntiseraOrderedTest.LastUpdateDate+",";
			insertSql += TABLES.AntiseraOrderedTest.LastUpdateFunctionId+",";
			insertSql += TABLES.AntiseraOrderedTest.LastUpdateUser+",";
			insertSql += TABLES.AntiseraOrderedTest.OrderedTestGuid+",";
			insertSql += TABLES.AntiseraOrderedTest.RackLotGuid+",";
			insertSql += TABLES.AntiseraOrderedTest.RecordStatusCode+") VALUES (";
			insertSql += "'"+antiseraOrderedTestGuid.ToString()+"',";
			insertSql += "'"+DateTime.Now.ToString()+"',";
			insertSql += "'"+Convert.ToInt32(Common.UpdateFunction.UnitTests).ToString()+"',";
			insertSql += "'"+Environment.UserName+"',";
			insertSql += "'"+orderedTestGuid.ToString()+"',";
			insertSql += "'"+drRackLot[TABLES.RackLot.RackLotGuid].ToString()+"',";
			insertSql += "'"+Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active)+"')";
			UnitTestUtil.RunSQL(insertSql);
			//
			//Now retrieve it
			DataTable dtAntiseraOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT AntiseraOrderedTestGuid,RecordStatusCode,RowVersion FROM AntiseraOrderedTest WHERE AntiseraOrderedTestGuid = '"+antiseraOrderedTestGuid.ToString()+"'");
			dtAntiseraOrderedTest.Rows[0][TABLES.AntiseraOrderedTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
			//
			System.Guid[] workloadGuids = {System.Guid.NewGuid()};
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.DATQC);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.DATQC,workloadGuids, Common.WorkloadTransactionType.Order, false);
			//
			//
			bool retValue = DAL.SpecimenTest.InvalidateSpecimenTestResults(dtSpecimenTest, dtOrderedTest, dtWorkload, dtTransfusionRequirement,dtPatient,dtAntiseraOrderedTest,Common.UpdateFunction.UnitTests);
			
			if (retValue)
			{
				int uCheck = UnitTestUtil.RunSQL("UPDATE SpecimenTest SET RecordStatusCode = 'A', InactivateDate = NULL, InactivateUser = NULL WHERE SpecimenTestGuid = '" + this._dtSpecimenTest.Rows[0][TABLES.SpecimenTest.SpecimenTestGuid].ToString() + "'");
				uCheck = UnitTestUtil.RunSQL("UPDATE PatientTransfusionRequirement SET RecordStatusCode = 'A', InactivationComment = NULL, InactivateDate = NULL, InactivateUser = NULL, InactivateDivisionCode = NULL WHERE PatientTransfusionRequirementGuid = '" + dr[TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid].ToString() + "'");
			}

			Assert.IsTrue(retValue, "ReturnValue");
		}


		[Test]
		public void InvalidateSpecimenTestResults_Fail()
		{
			System.Guid orderedTestGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];
			byte[] otRowVersion = new byte[8];

			System.Guid specimenTestGuid = (System.Guid)this._dtSpecimenTest.Rows[0][TABLES.SpecimenTest.SpecimenTestGuid];
			byte[] stRowVersion = new byte[8];

			DataTable dtSpecimenTest = SprocHelper.GetUpdateSpecimenTestStatusSprocTable(specimenTestGuid, stRowVersion);
			DataTable dtOrderedTest = SprocHelper.GetUpdateOrderedTestStatusSprocTable(orderedTestGuid, otRowVersion);
			dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid] = this._dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid];

			DataTable dtWorkload = null;
			DataTable dtTransfusionRequirement = null;
			DataTable dtPatient = null;

			dtSpecimenTest.Columns.Remove(TABLES.SpecimenTest.RowVersion);

			try
			{
				DAL.SpecimenTest.InvalidateSpecimenTestResults(dtSpecimenTest, dtOrderedTest, dtWorkload, dtTransfusionRequirement,dtPatient,null,Common.UpdateFunction.UnitTests);
				Assert.IsTrue(false, "ArgumentException Expected");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.RowVersion, typeof(byte[]));
			dtOrderedTest.Columns.Remove(TABLES.OrderedTest.RowVersion);

			try
			{
				DAL.SpecimenTest.InvalidateSpecimenTestResults(dtSpecimenTest, dtOrderedTest, dtWorkload, dtTransfusionRequirement,dtPatient,null,Common.UpdateFunction.UnitTests);
				Assert.IsTrue(false, "ArgumentException Expected");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void InvalidateSpecimenTestResults_Fail2()
		{
			System.Guid orderedTestGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];
			byte[] otRowVersion = new byte[8];

			System.Guid specimenTestGuid = (System.Guid)this._dtSpecimenTest.Rows[0][TABLES.SpecimenTest.SpecimenTestGuid];
			byte[] stRowVersion = new byte[8];

			DataTable dtSpecimenTest = SprocHelper.GetUpdateSpecimenTestStatusSprocTable(specimenTestGuid, stRowVersion);
			DataTable dtOrderedTest = SprocHelper.GetUpdateOrderedTestStatusSprocTable(orderedTestGuid, otRowVersion);
			dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid] = this._dtOrderedTest.Rows[0][TABLES.OrderedTest.PatientSpecimenGuid];

			DataTable dtWorkload = null;
			DataTable dtTransfusionRequirement = null;
			DataTable dtPatient = null;

			dtSpecimenTest.Rows[0][TABLES.SpecimenTest.RowVersion] = new byte[8];

			try
			{
				DAL.SpecimenTest.InvalidateSpecimenTestResults(dtSpecimenTest, dtOrderedTest, dtWorkload, dtTransfusionRequirement,dtPatient,null,Common.UpdateFunction.UnitTests);
				Assert.IsTrue(false, "1-RowVersionException Expected");
			}
			catch(Common.RowVersionException)
			{
				Assert.IsTrue(true);
			}

			dtSpecimenTest.Rows[0][TABLES.SpecimenTest.RowVersion] = this._dtSpecimenTest.Rows[0][TABLES.SpecimenTest.RowVersion];
			dtOrderedTest.Rows[0][TABLES.OrderedTest.RowVersion] = new byte[8];

			try
			{
				DAL.SpecimenTest.InvalidateSpecimenTestResults(dtSpecimenTest, dtOrderedTest, dtWorkload, dtTransfusionRequirement,dtPatient,null,Common.UpdateFunction.UnitTests);
				Assert.IsTrue(false, "2-RowVersionException Expected");
			}
			catch(Common.RowVersionException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetOffSiteAntibodyIDs_Pass()
		{
			DataTable dtTest = DAL.SpecimenTest.GetOffSiteAntibodyIDs(_currentDateTime.AddYears(-1), _currentDateTime);
			
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OffsiteLocation), TABLES.SpecimenTest.OffsiteLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OffsiteCost), TABLES.SpecimenTest.OffsiteCost);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestDate), TABLES.SpecimenTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
		}

		[Test]
		public void GetOffSiteAntibodyIDs_Fail()
		{
			DataTable dtOffSiteABIDs = DAL.SpecimenTest.GetOffSiteAntibodyIDs(_currentDateTime.AddDays(1), _currentDateTime);
			
			Assert.AreEqual(0, dtOffSiteABIDs.Rows.Count, "Rows.Count");
		}

	}
}
#endif
